(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15808,        418]
NotebookOptionsPosition[     12922,        362]
NotebookOutlinePosition[     13488,        383]
CellTagsIndexPosition[     13445,        380]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Chapter 1, Section 1.5, Figure 1.3", "Section",ExpressionUUID->"5ccf81f8-b0b3-4a95-bf76-a3d671032f98"],

Cell["\<\
Enter the orbital periods of the five major uranian satellites (Miranda, \
Ariel, Umbriel, Titania and Oberon).\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"62f4fe7d-680d-426e-828d-034f3f174fa4"],

Cell["period = {1.413, 2.520, 4.144, 8.706, 13.463};", "Input",
 AspectRatioFixed->True,
 CellLabel->"In[24]:=",ExpressionUUID->"8371f505-2d10-4938-97ef-c02a70ae6930"],

Cell["Take the logarithm (base 10) of each period.", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"631f8066-5e12-4fa2-b63b-1719f0d471b0"],

Cell[CellGroupData[{

Cell["Lperiod = Log[10,period]", "Input",
 AspectRatioFixed->True,
 CellLabel->"In[25]:=",ExpressionUUID->"9092c7ff-06db-45d8-87ba-0a088dd28689"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.1501421618485586`", ",", "0.401400540781544`", ",", 
   "0.6174197467371766`", ",", "0.9398186628213793`", ",", 
   "1.1291418457922853`"}], "}"}]], "Output",
 CellChangeTimes->{3.802853963695833*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"69727f1c-30b6-4bf0-9989-81ae27668761"]
}, Open  ]],

Cell[TextData[{
 "Carry out a linear least squares fit to the data using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ",
 StyleBox["Fit", "Input"],
 " command.  Here ",
 StyleBox["i",
  FontSlant->"Italic"],
 "=1",
 " denotes Miranda, ",
 StyleBox["i",
  FontSlant->"Italic"],
 "=2 is Ariel, ",
 StyleBox["i",
  FontSlant->"Italic"],
 "=3 is Umbriel, ",
 StyleBox["i",
  FontSlant->"Italic"],
 "=4 is Titania and ",
 StyleBox["i",
  FontSlant->"Italic"],
 "=5 is Oberon."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"4fd8fa4d-868f-4705-8464-9a446c99136a"],

Cell[CellGroupData[{

Cell["fn = Fit[Lperiod, {1,i}, {i}]", "Input",
 AspectRatioFixed->True,
 CellLabel->"In[26]:=",ExpressionUUID->"b52f93fe-7d8f-4a98-a1e1-42bb9ae7cde1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.10134065538199818`"}], "+", 
  RowBox[{"0.24964174899272892`", " ", "i"}]}]], "Output",
 CellChangeTimes->{3.802853963713475*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"52ebb1d3-df08-4864-99ac-2f3017b652b0"]
}, Open  ]],

Cell[TextData[{
 "Now calculate values of this function for each value of ",
 StyleBox["i",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"8aab3596-a2ec-48fe-ad4d-99a37752c3d9"],

Cell[CellGroupData[{

Cell["calc = Table[fn, {i,1,5}]", "Input",
 AspectRatioFixed->True,
 CellLabel->"In[27]:=",ExpressionUUID->"2765a4ff-eb3c-47fb-9e14-e15780e9afa1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.14830109361073074`", ",", "0.3979428426034597`", ",", 
   "0.6475845915961885`", ",", "0.8972263405889175`", ",", 
   "1.1468680895816463`"}], "}"}]], "Output",
 CellChangeTimes->{3.802853963717939*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"d9711f50-c209-4f78-950c-185e9296a634"]
}, Open  ]],

Cell["Use these to calculate the fitted orbital period.", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"b83e0da8-b613-43bc-a39f-1b165600d5e1"],

Cell[CellGroupData[{

Cell["10^calc", "Input",
 AspectRatioFixed->True,
 CellLabel->"In[28]:=",ExpressionUUID->"1abb26df-4cab-4ac7-a0af-e5ad1a7611de"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.407022665954343`", ",", "2.5000163134738433`", ",", "4.442061751291045`",
    ",", "7.892713537882808`", ",", "14.023876856951185`"}], "}"}]], "Output",\

 CellChangeTimes->{3.802853963722493*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"9fcea2db-367b-4248-b3b0-ab882a05a63f"]
}, Open  ]],

Cell["Plot the observed orbital periods ...", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"5e908457-e239-4281-b96e-b4b75dd3fbc0"],

Cell[CellGroupData[{

Cell["\<\
lp = 
ListPlot[
Lperiod, Frame->True, PlotRange->{{0,6},{0,1.4}},
AxesOrigin->{0,0}]\
\>", "Input",
 AspectRatioFixed->True,
 CellLabel->"In[29]:=",ExpressionUUID->"b8bb63d6-ae7f-4df7-948f-5b039d5d6efc"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`], 
    AbsoluteThickness[1.6], 
    PointBox[{{1., 0.1501421618485586}, {2., 0.401400540781544}, {3., 
     0.6174197467371766}, {4., 0.9398186628213793}, {5., 
     1.1291418457922853`}}]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 6}, {0, 1.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.802853963786386*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"b7bb73a3-fc9c-4e55-887d-3c0641aa6741"]
}, Open  ]],

Cell["... the fitted orbital periods ...", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"df9c593e-b874-4751-95f1-225fb092894a"],

Cell[CellGroupData[{

Cell["\<\
fittedlp = 
Plot[fn, {i,0,6},
Frame->True, PlotRange->{{0,6},{0,1.4}},
AxesOrigin->{0,0}]\
\>", "Input",
 AspectRatioFixed->True,
 CellLabel->"In[30]:=",ExpressionUUID->"9008d619-99fd-43be-aab5-d1795cf02a21"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwtkY871HccwC+Vs8tv5z7R/Eh46Mdz/fC78X6nsGaL2DmRa86PSAmbCrGo
a9Y6+VHbIsmeDI8fK5WmJxaVXZZWuyMqF7Lzc+HOfTk6t/Y8ez3P63n9Aa/V
/MNBMVo0Gm3He//rXosLKvV8L9D+53ZaTF/FMyk41amUguAi6A1LYKccfQOS
7+Xj/tJqMPITxrbiMBS/YLios26CoSSmwTV8HO5clzGHr92FNdYHqwX8SUh2
dl7vx2sDt75Df2wrnIZz8W2bhizboXX+xKeSEgWUt948fWZjB8T9JhK15Chh
W3IKzL/rhItRleamX8yCXMebY/vyKWwIHaAWY1TglZC5ObD/L5AqAp7gzgUI
TLvc2t8mAflrs40sjhp4Zilzys5uyK9J38/lamDi+uHc9D97wN5A57NjJTRE
Kqgjqv4FNCadqMkrW4KFj0duPLv1CiR2RfTdhVpYtSs64GqxFGxPih0iLi7F
iE07H6mD+8E98LVTWcky/Nk1lQxwBqAvSeAlPLscxSbnW474DkKD+x69hwXa
qHY727TL/w2wQn7vrRLQkeF0VK/XawhgkFbQ9pUOctfN6pVs+BsusuL07I99
gD8lBPLLNsog53L8N84HGPg0+5JBiM0wlD75sT0vaQW+6281DHAYgczEoimL
FF088NHxlq8dR2E80mHlHr4eNh1yfMg3G4Pv1GPLpLH6qD3yi1WuxfsPE36T
+mEG6OLmKN5nOAHddm6DHraGePWU65bDixMQ5xjFLqowRGNzq+F7tLfQGhKe
sc3SCPkCleLB9FvYEjpWzSw3wnr3us9XzE7CwZO+zz1XGePkgCM9J3UKcmN1
5pcUGaNDhZ+H+T9T0GwRqRljmmC/btAP4sRpaFo8vXRtngnmvu6ylg1Pw5Mb
28eERky8FuIrMUuQw0Pr2PazhUyc81/CGx2Xw6nbnPIBhilurnVmGkcrYK/N
K1640BTHr4XMhMsUsNDIXrWOzsLz1tM0zb4ZOL509PGFLBby9LvfeD6fAZat
e6QdjWDllcqp0lAlHE0MmWGkERwolTtynynhQ5dokX0GQemuWdcUsRLuqZMv
eWcSfKlZ8BF2KYEhFO5IzybYFbmcf79XCZdrHpwf/ZZgh93KYvagEtpHNjuL
igneqvNk6CiUwIwyOCK4SzC3OXfsVyYFTWstPilvIShIFM6JWRTw5Gstm+8R
zLEq1J5cSUFVtm/7zAOCmdklNnYWFGy9ksmK7iSY7FMfVmBHAb9vvNFbSjC8
U9wR70IBvUJ1htdPMDSrp+eUGwW1B+n70gcJcth9sjIPCqgFG3qDjGBggUyr
24uCM+Zh3NWTBH04Kg9vPwrYg/vXeU4T3K69+HHETgok1amaUAVBvK3FPeZP
gaV7QWX+LMGtZrpf1gdQcJ9WllGrIujWYZj9aDcFcaLaANECQecM03NDwRTo
5t9ZM6QmuGm9eamGQ8F1rmhWoyHI7rOsMQ+l4F8BTQLN
       "]]},
     Annotation[#, "Charting`Private`Tag$5912#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 6}, {0, 1.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8028539638295927`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"07032d32-7a21-44b3-826a-4ffbe0dfc245"]
}, Open  ]],

Cell["... and show them both together.", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"8ace4594-4ae7-4c43-a923-74f0ad94b04f"],

Cell[CellGroupData[{

Cell["Show[lp,fittedlp]", "Input",
 AspectRatioFixed->True,
 CellLabel->"In[31]:=",ExpressionUUID->"7e399388-7625-4eb1-bc09-29872e5cbb60"],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], 
     PointBox[{{1., 0.1501421618485586}, {2., 0.401400540781544}, {3., 
      0.6174197467371766}, {4., 0.9398186628213793}, {5., 
      1.1291418457922853`}}]}, {{}, {}}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwtkY871HccwC+Vs8tv5z7R/Eh46Mdz/fC78X6nsGaL2DmRa86PSAmbCrGo
a9Y6+VHbIsmeDI8fK5WmJxaVXZZWuyMqF7Lzc+HOfTk6t/Y8ez3P63n9Aa/V
/MNBMVo0Gm3He//rXosLKvV8L9D+53ZaTF/FMyk41amUguAi6A1LYKccfQOS
7+Xj/tJqMPITxrbiMBS/YLios26CoSSmwTV8HO5clzGHr92FNdYHqwX8SUh2
dl7vx2sDt75Df2wrnIZz8W2bhizboXX+xKeSEgWUt948fWZjB8T9JhK15Chh
W3IKzL/rhItRleamX8yCXMebY/vyKWwIHaAWY1TglZC5ObD/L5AqAp7gzgUI
TLvc2t8mAflrs40sjhp4Zilzys5uyK9J38/lamDi+uHc9D97wN5A57NjJTRE
Kqgjqv4FNCadqMkrW4KFj0duPLv1CiR2RfTdhVpYtSs64GqxFGxPih0iLi7F
iE07H6mD+8E98LVTWcky/Nk1lQxwBqAvSeAlPLscxSbnW474DkKD+x69hwXa
qHY727TL/w2wQn7vrRLQkeF0VK/XawhgkFbQ9pUOctfN6pVs+BsusuL07I99
gD8lBPLLNsog53L8N84HGPg0+5JBiM0wlD75sT0vaQW+6281DHAYgczEoimL
FF088NHxlq8dR2E80mHlHr4eNh1yfMg3G4Pv1GPLpLH6qD3yi1WuxfsPE36T
+mEG6OLmKN5nOAHddm6DHraGePWU65bDixMQ5xjFLqowRGNzq+F7tLfQGhKe
sc3SCPkCleLB9FvYEjpWzSw3wnr3us9XzE7CwZO+zz1XGePkgCM9J3UKcmN1
5pcUGaNDhZ+H+T9T0GwRqRljmmC/btAP4sRpaFo8vXRtngnmvu6ylg1Pw5Mb
28eERky8FuIrMUuQw0Pr2PazhUyc81/CGx2Xw6nbnPIBhilurnVmGkcrYK/N
K1640BTHr4XMhMsUsNDIXrWOzsLz1tM0zb4ZOL509PGFLBby9LvfeD6fAZat
e6QdjWDllcqp0lAlHE0MmWGkERwolTtynynhQ5dokX0GQemuWdcUsRLuqZMv
eWcSfKlZ8BF2KYEhFO5IzybYFbmcf79XCZdrHpwf/ZZgh93KYvagEtpHNjuL
igneqvNk6CiUwIwyOCK4SzC3OXfsVyYFTWstPilvIShIFM6JWRTw5Gstm+8R
zLEq1J5cSUFVtm/7zAOCmdklNnYWFGy9ksmK7iSY7FMfVmBHAb9vvNFbSjC8
U9wR70IBvUJ1htdPMDSrp+eUGwW1B+n70gcJcth9sjIPCqgFG3qDjGBggUyr
24uCM+Zh3NWTBH04Kg9vPwrYg/vXeU4T3K69+HHETgok1amaUAVBvK3FPeZP
gaV7QWX+LMGtZrpf1gdQcJ9WllGrIujWYZj9aDcFcaLaANECQecM03NDwRTo
5t9ZM6QmuGm9eamGQ8F1rmhWoyHI7rOsMQ+l4F8BTQLN
        "]]},
      Annotation[#, "Charting`Private`Tag$5912#1"]& ]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 6}, {0, 1.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8028539638393373`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"04e51216-3e32-48a8-9330-22490bab7aa8"]
}, Open  ]]
},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{811, 845},
WindowMargins->{{41, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"94fb802a-11b1-4349-9203-e41298130e70"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 108, 0, 67, "Section",ExpressionUUID->"5ccf81f8-b0b3-4a95-bf76-a3d671032f98"],
Cell[669, 22, 245, 6, 49, "Text",ExpressionUUID->"62f4fe7d-680d-426e-828d-034f3f174fa4"],
Cell[917, 30, 167, 2, 30, "Input",ExpressionUUID->"8371f505-2d10-4938-97ef-c02a70ae6930"],
Cell[1087, 34, 170, 3, 53, "Text",ExpressionUUID->"631f8066-5e12-4fa2-b63b-1719f0d471b0"],
Cell[CellGroupData[{
Cell[1282, 41, 145, 2, 30, "Input",ExpressionUUID->"9092c7ff-06db-45d8-87ba-0a088dd28689"],
Cell[1430, 45, 324, 7, 34, "Output",ExpressionUUID->"69727f1c-30b6-4bf0-9989-81ae27668761"]
}, Open  ]],
Cell[1769, 55, 605, 26, 76, "Text",ExpressionUUID->"4fd8fa4d-868f-4705-8464-9a446c99136a"],
Cell[CellGroupData[{
Cell[2399, 85, 150, 2, 30, "Input",ExpressionUUID->"b52f93fe-7d8f-4a98-a1e1-42bb9ae7cde1"],
Cell[2552, 89, 250, 5, 34, "Output",ExpressionUUID->"52ebb1d3-df08-4864-99ac-2f3017b652b0"]
}, Open  ]],
Cell[2817, 97, 242, 8, 53, "Text",ExpressionUUID->"8aab3596-a2ec-48fe-ad4d-99a37752c3d9"],
Cell[CellGroupData[{
Cell[3084, 109, 146, 2, 30, "Input",ExpressionUUID->"2765a4ff-eb3c-47fb-9e14-e15780e9afa1"],
Cell[3233, 113, 326, 7, 34, "Output",ExpressionUUID->"d9711f50-c209-4f78-950c-185e9296a634"]
}, Open  ]],
Cell[3574, 123, 175, 3, 53, "Text",ExpressionUUID->"b83e0da8-b613-43bc-a39f-1b165600d5e1"],
Cell[CellGroupData[{
Cell[3774, 130, 128, 2, 30, "Input",ExpressionUUID->"1abb26df-4cab-4ac7-a0af-e5ad1a7611de"],
Cell[3905, 134, 320, 7, 34, "Output",ExpressionUUID->"9fcea2db-367b-4248-b3b0-ab882a05a63f"]
}, Open  ]],
Cell[4240, 144, 163, 3, 53, "Text",ExpressionUUID->"5e908457-e239-4281-b96e-b4b75dd3fbc0"],
Cell[CellGroupData[{
Cell[4428, 151, 213, 7, 84, "Input",ExpressionUUID->"b8bb63d6-ae7f-4df7-948f-5b039d5d6efc"],
Cell[4644, 160, 1301, 34, 250, "Output",ExpressionUUID->"b7bb73a3-fc9c-4e55-887d-3c0641aa6741"]
}, Open  ]],
Cell[5960, 197, 160, 3, 53, "Text",ExpressionUUID->"df9c593e-b874-4751-95f1-225fb092894a"],
Cell[CellGroupData[{
Cell[6145, 204, 218, 7, 84, "Input",ExpressionUUID->"9008d619-99fd-43be-aab5-d1795cf02a21"],
Cell[6366, 213, 3164, 68, 250, "Output",ExpressionUUID->"07032d32-7a21-44b3-826a-4ffbe0dfc245"]
}, Open  ]],
Cell[9545, 284, 158, 3, 53, "Text",ExpressionUUID->"8ace4594-4ae7-4c43-a923-74f0ad94b04f"],
Cell[CellGroupData[{
Cell[9728, 291, 138, 2, 30, "Input",ExpressionUUID->"7e399388-7625-4eb1-bc09-29872e5cbb60"],
Cell[9869, 295, 3037, 64, 273, "Output",ExpressionUUID->"04e51216-3e32-48a8-9330-22490bab7aa8"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

